<?php
/**
 * Kortez Construction FSE functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Kortez Construction FSE
 */

if ( ! defined( 'KORTEZ_CONSTRUCTION_FSE_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'KORTEZ_CONSTRUCTION_FSE_VERSION', wp_get_theme()->get( 'Version' ) );
}

define( 'KORTEZ_CONSTRUCTION_FSE_URL', trailingslashit( get_template_directory_uri() ) );

if ( ! function_exists( 'kortez_construction_fse_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function kortez_construction_fse_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Kortez Construction FSE, use a find and replace
		 * to change 'kortez-construction-fse' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'kortez-construction-fse', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'align-wide' );

		// Add support for block styles.
		add_theme_support( 'wp-block-styles' );
	}
endif;
add_action( 'after_setup_theme', 'kortez_construction_fse_setup' );

/**
 * Enqueue scripts and styles.
 */
function kortez_construction_fse_scripts() {
	$theme_version = wp_get_theme()->get( 'Version' );

	// Register theme stylesheet.
	wp_enqueue_style( 'kortez-construction-fse-styles', get_theme_file_uri( '/style.css' ), array(), $theme_version );
}
add_action( 'wp_enqueue_scripts', 'kortez_construction_fse_scripts' );

/**
 * Info
 */
require get_theme_file_path( '/inc/admin/info.php' );

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	function kortez_construction_fse_register_block_styles() {
		// Box shadow for columns, column, group and image
		register_block_style(
			'core/columns',
			array(
				'name'  => 'sb-box-shadow',
				'label' => __( 'Box Shadow', 'kortez-construction-fse' )
			)
		);

		register_block_style(
			'core/column',
			array(
				'name'  => 'sb-box-shadow',
				'label' => __( 'Box Shadow', 'kortez-construction-fse' )
			)
		);
		register_block_style(
			'core/column',
			array(
				'name'  => 'sb-box-shadow-medium',
				'label' => __( 'Box Shadow Medium', 'kortez-construction-fse' )
			)
		);
		register_block_style(
			'core/column',
			array(
				'name'  => 'sb-box-shadow-large',
				'label' => __( 'Box Shadow Large', 'kortez-construction-fse' )
			)
		);

		register_block_style(
			'core/group',
			array(
				'name'  => 'sb-box-shadow',
				'label' => __( 'Box Shadow', 'kortez-construction-fse' )
			)
		);
		register_block_style(
			'core/group',
			array(
				'name'  => 'sb-box-shadow-medium',
				'label' => __( 'Box Shadow Medium', 'kortez-construction-fse' )
			)
		);
		register_block_style(
			'core/group',
			array(
				'name'  => 'sb-box-shadow-large',
				'label' => __( 'Box Shadow Larger', 'kortez-construction-fse' )
			)
		);
		register_block_style(
			'core/image',
			array(
				'name'  => 'sb-box-shadow',
				'label' => __( 'Box Shadow', 'kortez-construction-fse' )
			)
		);
		register_block_style(
			'core/image',
			array(
				'name'  => 'sb-box-shadow-medium',
				'label' => __( 'Box Shadow Medium', 'kortez-construction-fse' )
			)
		);
		register_block_style(
			'core/image',
			array(
				'name'  => 'sb-box-shadow-larger',
				'label' => __( 'Box Shadow Large', 'kortez-construction-fse' )
			)
		);
		register_block_style(
			'core/image',
			array(
				'name'  => 'sb-box-shadow-hover',
				'label' => __( 'Box Shadow on Hover', 'kortez-construction-fse' )
			)
		);
		register_block_style(
			'core/columns',
			array(
				'name'  => 'sb-box-shadow-hover',
				'label' => __( 'Box Shadow on Hover', 'kortez-construction-fse' )
			)
		);

		register_block_style(
			'core/column',
			array(
				'name'  => 'sb-box-shadow-hover',
				'label' => __( 'Box Shadow on Hover', 'kortez-construction-fse' )
			)
		);

		register_block_style(
			'core/group',
			array(
				'name'  => 'sb-box-shadow-hover',
				'label' => __( 'Box Shadow on Hover', 'kortez-construction-fse' )
			)
		);

		// Secondary button
		register_block_style(
			'core/button',
			array(
				'name'   => 'sb-button-secondary',
				'label'  => __( 'Secondary', 'kortez-construction-fse' )
			)
		);
	}
	add_action( 'init', 'kortez_construction_fse_register_block_styles' );
}

/* MihanWP 2025-07-27 */
function add_custom_footer_message() {
    echo '<p style="text-align: center; font-size: 14px;">توسعه توسط تیم <a href="https://saninai.com" target="_blank">سانین</a></p>';
}
add_action('wp_footer', 'add_custom_footer_message');